import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = ConEvents;
type ConEvents = BaseOpenAPIClient & {
    IsAnyServiceConsoleAvailable(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    IsServiceConsoleAvailable({ wstrProdName, wstrProdVersion }: {
        wstrProdName: string,
        wstrProdVersion: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    Retrieve(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    Subscribe({ wstrEvent, pFilter }: {
        wstrEvent: string,
        pFilter: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    UnSubscribe({ nSubsId }: {
        nSubsId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}
