import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = DataProtectionApi;
type DataProtectionApi = BaseOpenAPIClient & {
    CheckPasswordSplPpc({ szwPassword }: {
        szwPassword: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    ProtectDataForHost({ szwHostId, pData }: {
        szwHostId: string,
        pData: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    ProtectDataGlobally({ pData }: {
        pData: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    ProtectUtf8StringForHost({ szwHostId, szwPlainText }: {
        szwHostId: string,
        szwPlainText: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    ProtectUtf8StringGlobally({ szwPlainText }: {
        szwPlainText: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    ProtectUtf16StringForHost({ szwHostId, szwPlainText }: {
        szwHostId: string,
        szwPlainText: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    ProtectUtf16StringGlobally({ szwPlainText }: {
        szwPlainText: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>
}
