import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { CloudType } from '../../constants/CloudType';
import BaseOpenAPIClient = require('../base-open-api-client');

export = DatabaseInfo;
type DatabaseInfo = BaseOpenAPIClient & {
    GetDBSize(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    GetDBDataSize(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    GetDBEventsCount(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    CheckBackupPath(params: { szwPath: string }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    CheckBackupPath2({ szwWinPath, szwLinuxPath }: {
        szwWinPath: string,
        szwLinuxPath: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    /**
     * @deprecated use DatabaseInfo.CheckBackupCloudPath2 instead.
     */
    CheckBackupCloudPath({ nCloudType, szwCloudPath, szwClientId, pSecretChunk, szwStorageKey, szwAzureResName, szwAzureResGroup, szwAzureAppID }: {
        nCloudType: CloudType,
        szwCloudPath: string,
        szwClientId: string,
        pSecretChunk: string,
        szwStorageKey: string,
        szwAzureResName: string,
        szwAzureResGroup: string,
        szwAzureAppID: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    CheckBackupCloudPath2({ nCloudType, szwCloudPath, szwClientId, pSecretChunk, pStorageKey, szwAzureResName, szwAzureResGroup, szwAzureAppID }: {
        nCloudType: CloudType,
        szwCloudPath: string,
        szwClientId: string,
        pSecretChunk: string,
        pStorageKey: string,
        szwAzureResName: string,
        szwAzureResGroup: string,
        szwAzureAppID: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    IsCloudSQL(args: { nCloudType: CloudType }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    IsLinuxSQL(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>
}
