import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { EventsNotificationSettings } from '../../additional/EventsNotificationSettings'
import { EventsNotificationLimits } from '../../additional/EventsNotificationLimits'
import BaseOpenAPIClient = require('../base-open-api-client');

export = EventNotificationProperties;
type EventNotificationProperties = BaseOpenAPIClient & {
    GetDefaultSettings(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<EventsNotificationSettings>,
    GetNotificationLimits(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<EventsNotificationLimits>,
    SetDefaultSettings({ pSettings }: {
        pSettings: EventsNotificationSettings
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    SetNotificationLimits({ pSettings }: {
        pSettings: EventsNotificationLimits
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    TestNotification({ eType, pSettings }: {
        eType: number,
        pSettings: EventsNotificationSettings
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}
