import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { VecFieldToOrder } from '../../data/common'
import BaseOpenAPIClient = require('../base-open-api-client');

export = EventProcessingFactory;
type EventProcessingFactory = BaseOpenAPIClient & {
    CreateEventProcessing({ vecFieldsToReturn, vecFieldsToOrder, lifetimeSec }: {
        vecFieldsToReturn?: Array<string>,
        vecFieldsToOrder?: VecFieldToOrder[],
        lifetimeSec?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    CreateEventProcessing2({ pFilter, vecFieldsToReturn, vecFieldsToOrder, lifetimeSec }: {
        pFilter: Record<string, unknown>,
        vecFieldsToReturn?: Array<string>,
        vecFieldsToOrder?: VecFieldToOrder[],
        lifetimeSec?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{ strIteratorId: string }>,
    CreateEventProcessingForHost2({ strDomainName, strHostName, strProduct, strVersion, pFilter, vecFieldsToReturn, vecFieldsToOrder, lifetimeSec }: {
        strDomainName: string,
        strHostName: string,
        strProduct: string,
        strVersion: string,
        pFilter: Record<string, unknown>,
        lifetimeSec?: number,
        vecFieldsToReturn?: Array<string>,
        vecFieldsToOrder?: VecFieldToOrder[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>
}
