import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { ParamLong } from '../../data/common'
import BaseOpenAPIClient = require('../base-open-api-client');

export = EventProcessing;
type EventProcessing = BaseOpenAPIClient & {
    GetRecordCount({ strIteratorId }: {
        strIteratorId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    GetRecordRange<T>({ strIteratorId, nStart, nEnd }: {
        strIteratorId: string,
        nStart: number,
        nEnd: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{
        KLEVP_EVENT_RANGE_ARRAY: T[]
    }>,
    InitiateDelete({ strIteratorId, pSettings }: {
        strIteratorId: string,
        events?: {
            EVP_EVENT_BLOCKS: {
                EVP_EVENT_BLOCK_BEGIN_ID: ParamLong,
                EVP_EVENT_BLOCK_END_ID: ParamLong
            }
        },
        pSettings?: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    ReleaseIterator({ strIteratorId }: {
        strIteratorId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    fetchEventsForHost<T = unknown>({ iteratorParams: { strDomainName, strHostName, strProduct, strVersion, vecFieldsToReturn } }: {
        iteratorParams: {
            strDomainName: string,
            strHostName: string,
            strProduct: string,
            strVersion: string,
            vecFieldsToReturn?: Array<string>
        }
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{
        KLEVP_EVENT_RANGE_ARRAY: T[]
    }>
}
