import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { ExtAuditObjectTypes } from '../../constants/ExtAuditObjectTypes'
import BaseOpenAPIClient = require('../base-open-api-client')

export = ExtAud;
type ExtAud = BaseOpenAPIClient & {
    GetRevision({ nObjId, nObjType, nObjRevision }: {
        nObjId: bigint,
        nObjType: ExtAuditObjectTypes,
        nObjRevision: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    UpdateRevisionDesc({ nObjId, nObjType, nObjRevision, wstrNewDescription }: {
        nObjId: bigint,
        nObjType: ExtAuditObjectTypes,
        nObjRevision: number,
        wstrNewDescription: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    FinalDelete({ arrObjects }: {
        arrObjects: Array<unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>
}
