import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = FilesAcceptor;
type FilesAcceptor = BaseOpenAPIClient & {
    InitiateFileUpload({ bIsArchive, qwFileSize }: {
        bIsArchive: boolean,
        qwFileSize: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{
        wstrFileId: string,
        wstrUploadURL: string
    }>,
    CancelFileUpload({ wstrFileId }: {
        wstrFileId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}
