import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { CustomCategory, Expression } from '../../additional/CustomCategory'
import BaseOpenAPIClient = require('../base-open-api-client');

export = FileCategorizer2;
type FileCategorizer2 = BaseOpenAPIClient & {
    GetCategory(nCategoryId: number, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{
        CategoryType: string,
        name: string,
        uuid: string,
        version: string,
        fromMaster: boolean,
        lastUpdateTime: number,
        inclusions: Expression[]
    }>,
    GetRefPolicies(nCatId: number, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{
        pPolicies: {
            RefPolicies: {
                value: string
            }[],
            PolId: number,
            PolName: string,
            GroupId: number,
            GroupName: string,
            VServerId: number,
            VServerName: string
        }
    }>,
    UpdateCategory({ nCategoryId, pCategory }: {
        nCategoryId: number,
        pCategory: CustomCategory
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    CreateCategory({ pCategory }: {
        pCategory: CustomCategory
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    DeleteCategory(nCategoryId: number, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    ForceCategoryUpdate(nCategoryId: number, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    InitFileUpload(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    CancelFileUpload(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetFilesMetadata(ulFlag: number, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    GetFileMetadata(ulFlag: number, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    GetFilesMetadataFromMSI(ulFlag: number, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>
}
