import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = Gcm;
type Gcm = BaseOpenAPIClient & {
    GetGcmServerSettings({ wstrSenderId, wstrApiKey }: {
        wstrSenderId: string,
        wstrApiKey: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    UpdateGcmServerSettings({ wstrSenderId, wstrApiKey }: {
        wstrSenderId: string,
        wstrApiKey: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    DeleteGcmServerSettings(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetGcmPropagation2VS({ bPropagate2VS }: {
        bPropagate2VS: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    SetGcmPropagation2VS({ bPropagate2VS }: {
        bPropagate2VS: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    CheckIfGcmServerSettingsPresent(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    CheckIfGcmServerSettingsShouldBeSet(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>
}
