import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = GroupSyncIterator;
type GroupSyncIterator = BaseOpenAPIClient & {
    GetNextItems({ szwIterator, nCount }: {
        szwIterator: string,
        nCount?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    ReleaseIterator({ szwIterator }: {
        szwIterator: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,

    /**
     * @deprecated
     */
    getAllItems(params: Record<string, unknown>): ApiResponsePromise<any>
}
