import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = GroupSync;
type GroupSync = BaseOpenAPIClient & {
    GetSyncInfo({ nSync, arrFieldsToReturn }: {
        nSync: number,
        arrFieldsToReturn: Array<string>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    GetSyncDeliveryTime({ nSync, szwHostId }: {
        nSync: number,
        szwHostId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    GetSyncHostsInfo({ nSync, arrFieldsToReturn, arrFieldsToOrder, nLifeTime }: {
        nSync: number,
        arrFieldsToReturn: Array<string>,
        arrFieldsToOrder: Array<unknown>,
        nLifeTime: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>
}
