import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { TaskSettings } from '../../data/task'
import BaseOpenAPIClient = require('../base-open-api-client');

export = GroupTaskControlApi;

type HostList = {
    HostDispName: string,
    Preliminary: boolean,
}

type TaskImportOptions = {
    PRTS_TASK_GROUPID?: number,
    HostList?: HostList[],
    ".HstQueryId"?: number
}

type TaskCommitInfo = {
    "klprts-TaskSystemFlag": boolean,
    "klprts-TaskHasPredefinedTargetList": boolean,
    KLTSK_RI_GROUP_TO_MOVE_HOST: number
}

type GroupTaskControlApi = BaseOpenAPIClient & {
    GetTaskByRevision({ nObjId, nRevision }: {
        nObjId: number,
        nRevision: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<TaskSettings>,
    RequestStatistics({ pTasksIds }: {
        pTasksIds: Array<number>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    RestoreTaskFromRevision({ nObjId, nRevision }: {
        nObjId: number,
        nRevision: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    ExportTask (params: { wstrTaskId: string }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    ImportTask (params: { pBlob: Blob, pExtraData: TaskImportOptions, skipSerialization?: boolean }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<TaskCommitInfo & { PxgRetVal: string }>,
    CommitImportedTask (params: { wstrId: string, bCommit: boolean }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>
}
