import {SrvViewFetchParams, SrvViewName, SrvViewRecords, SrvViewResult} from '../../srv-views'
import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client')

export = Helpers;

type Helpers = BaseOpenAPIClient & {
    SrvViewSilentFetch<ViewName extends SrvViewName>(
        params: SrvViewFetchParams<ViewName>, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<SrvViewResult<
        ViewName extends unknown ? Record<string, any> : SrvViewRecords[ViewName]
        >>,
    SrvViewCachedFetch<ViewName extends SrvViewName>(
        params: SrvViewFetchParams<ViewName>, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<SrvViewResult<
        ViewName extends unknown ? Record<string, any> : SrvViewRecords[ViewName]
        >>
}
