import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { IncidentsAttributes } from '../../data/incident'
import { GroupAttributes } from '../../data/group'
import { OpenAPIIterator, ParamDateTime, VecFieldToOrder } from '../../data/common'
import BaseOpenAPIClient = require('../base-open-api-client');

export = HostGroup;

type Group = {
    id: number,
    groups?: Group[]
} & GroupAttributes

type GroupIterator = OpenAPIIterator<Group>
type IncidentIterator = OpenAPIIterator<IncidentsAttributes>

type ExtraOptions = {
    KLSRVH_SLAVE_REC_DEPTH?: number,
    KLGRP_FIND_FROM_CUR_VS_ONLY?: boolean
}

type ServerStats = {
    KLSRV_ST_ALL_CONS_CNT: number,
    KLSRV_ST_NAG_CONS_CNT: number,
    KLSRV_ST_CTLNGT_CONS_CNT: number,
    KLSRV_ST_PING_CNT: number,
    KLSRV_ST_PING_REJECTED_CNT: number,
    KLSRV_ST_PING_ERROR_CNT: number,
    KLSRV_ST_PING_JN_CNT: number,
    KLSRV_ST_SYNC_CNT: number,
    KLSRV_ST_SYNC_REAL_CNT: number,
    KLSRV_ST_SYNC_SUC_CNT: number,
    KLSRV_ST_SYNC_JN_CNT: number,
    KLSRV_ST_NETWORK_SCANNED: boolean,
    KLSRV_ST_EVENTBULKS_CNT: number,
    KLSRV_ST_EVENTBULKS_REJECTED_CNT: number,
    KLSRV_ST_EVENTBULKS_ERROR_CNT: number,
    KLSRV_ST_EVENTBULKS_JN_CNT: number,
    KLSRV_ST_EVENTS_CNT: number,
    KLSRV_ST_EVENTS_REJECTED_CNT: number,
    KLSRV_ST_EVENTS_ERROR_CNT: number,
    KLSRV_ST_EVENTS_JN_CNT: number,
    KLSRV_ST_LAST_FULLNETSCAN_TIME: ParamDateTime,
    KLSRV_ST_LAST_FASTNETSCAN_TIME: ParamDateTime,
    KLSRV_ST_LAST_DPNSSCAN_TIME: ParamDateTime,
    KLSRV_ST_LAST_ADSCAN_TIME: ParamDateTime,
    KLSRV_ST_FULL_SCAN_PERCENT: number,
    KLSRV_ST_NETWORK_SCAN_PERCENT: number,
    KLSRV_ST_DPNS_SCAN_PERCENT: number,
    KLSRV_ST_AD_SCAN_PERCENT: number,
    KLSRV_ST_NETWORK_DOMAIN_SCANNED: string,
    KLSRV_ST_SYNC_QUEUE_SIZE: number,
    KLNLST_COUNTERS: Record<string, unknown>,
    KLASYNCACT_COUNTERS: Record<string, unknown>,
    KLSRV_ST_CPU_USER: bigint,
    KLSRV_ST_CPU_KERNEL: bigint,
    KLSRV_ST_GUI_CALLS_CNT: number,
    KLSRV_ST_VIRT_SERVER_COUNT: number,
    KLSRV_ST_TOTAL_HOSTS_COUNT: number,
    KLSRV_ST_VIRT_SERVERS_DETAILS: unknown,
    KLTR_ST_ACCEPTS_TOTAL: number,
    KLTR_ST_ACCEPTS_FAILED: number,
    KLTR_ST_SENT_BYTES: number,
    KLTR_ST_RECEIVED_BYTES: number,
    KLFTS_ST_GET_CHUNK_REQUESTS_TOTAL: number,
    KLFTS_ST_GET_CHUNK_REQUESTS_REJECTED: number,
    KLFTS_ST_TRANSMITTED_SIZE: number,
    KLSRV_ST_CON_EVENTS: Record<string, unknown>,
    KLLIC_ST_SUITABLE_LIC_CNT: number,
    KLSRV_ST_PIDS: Record<string, unknown>
}

type ProductVersionData = {
    InstallTime: any,
    InstallationId: string,
    DisplayName: string,
    BaseRecords: any,
    ConnDisplayName: string,
    ConnProdVersion: string,
    ConnectorComponentName: string,
    ProdVersion: string
}

type SsParam = {
    strHostName: string,
    strType?: string,
    strProduct: string,
    strVersion: string,
    strSection: string,
}

type HostGroup = BaseOpenAPIClient & {
    GroupIdGroups(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    GroupIdUnassigned(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    GroupIdSuper(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    GetGroupInfo({ nGroupId, deserialize }: {
        nGroupId: number,
        deserialize?: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<GroupAttributes>,
    GetGroupInfoEx({ nGroupId, pArrAttributes }: {
        nGroupId: number,
        pArrAttributes: string[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<GroupAttributes>,
    FindHosts({ wstrFilter, vecFieldsToReturn, vecFieldsToOrder, pParams, lMaxLifeTime, skipDeserialization }: {
        wstrFilter?: string,
        vecFieldsToReturn?: string[],
        vecFieldsToOrder?: VecFieldToOrder[],
        pParams?: {
            KLGRP_FIND_FROM_CUR_VS_ONLY: boolean
        },
        lMaxLifeTime?: number,
        skipDeserialization?: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<OpenAPIIterator>,
    MoveHostsToGroup({ nGroup, pHostNames }: {
        nGroup: number,
        pHostNames: Array<string>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    RemoveHosts({ pHostNames, bForceDestroy }: {
        pHostNames: Array<string>,
        bForceDestroy?: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetSubgroups(params: {
        nGroupId: number,
        nDepth: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Group[]>,
    AddGroup(params: { pInfo: GroupAttributes }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    UpdateGroup({ nGroup, pInfo }: {
        nGroup: number,
        pInfo: Partial<GroupAttributes>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    RemoveGroup({ nGroup, nFlags }: {
        nGroup: number,
        nFlags?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    ResolveAndMoveToGroup({ pInfo }: {
        pInfo: {
            KLHST_WKS_ANYNAME: string[], // Array of strings with the host names.
            KLHST_WKS_GROUPID: number // ID of the administration group to which the designated hosts will be placed.
        }
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{
        KLHST_WKS_RESULTS: boolean[]
    }>,
    FindGroups({ wstrFilter, vecFieldsToReturn, vecFieldsToOrder, pParams, lMaxLifeTime }: {
        wstrFilter: string,
        vecFieldsToReturn?: (keyof Group)[],
        vecFieldsToOrder?: VecFieldToOrder[],
        pParams?: ExtraOptions,
        lMaxLifeTime?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<GroupIterator>,
    GetStaticInfo(pValues: string[] | null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, any>>,
    GetRunTimeInfo(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    GetHostInfo({ strHostName, pFields2Return, deserialize }: {
        strHostName: string,
        pFields2Return: Array<string>,
        deserialize?: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, any>>,
    UpdateHost({ strHostName, pInfo }: {
        strHostName: string,
        pInfo: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, any>>,
    SS_GetNames({ strHostName, strType, strProduct, strVersion }: Required<Omit<SsParam, 'strSection'>>, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string[]>,
    SS_Read({ strHostName, strType, strProduct, strVersion, strSection, skipDeserialization }: SsParam & {
        skipDeserialization?: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, any>>,
    SS_Write({ strHostName, strType, strProduct, strVersion, strSection, nOption, pSettings, skipSerialization }: Required<SsParam> & {
        nOption: number,
        pSettings: Record<string, unknown>,
        skipSerialization?: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    SS_DeleteSection({ strHostName, strType, strProduct, strVersion, strSection }: SsParam, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    SS_CreateSection({ strHostName, strType, strProduct, strVersion, strSection }: SsParam, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    GetHostProducts({ strHostName }: {
        strHostName: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, Record<string, ProductVersionData>>>,
    FindUsers({ strFilter, pFieldsToReturn, pFieldsToOrder, lMaxLifeTime }: {
        strFilter: string,
        pFieldsToReturn: string[],
        pFieldsToOrder: Record<string, unknown>[],
        lMaxLifeTime?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<OpenAPIIterator>,
    GetHostTasks({ strHostName }: {
        strHostName: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    ZeroVirusCountForHosts({ pHostNames }: {
        pHostNames: Array<string>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    GetHostfixesForProductOnHost({ strHostName, strProductName, strProductVersion }: {
        strHostName: string,
        strProductName: string,
        strProductVersion: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{
        KLHST_HF_ID: string,
        KLHST_HF_DN : string
    }[]>,
    RestartNetworkScanning({ nType }: {
        /**
         * 1 - Active Directory
         * 2 - Quick scan of the Microsoft network
         * 3 - Full scan of the Microsoft network
         * 4 - Scan of the IP addresses diapasons
         */
        nType: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetGroupId({ nParent, strName }: {
        nParent: number,
        strName: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    GetDomains(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{
        KLHST_WKS_WINDOMAIN: string,
        /**
         * 0 - Windows NT domain.
         * 1 - Windows work group.
         */
        KLHST_WKS_WINDOMAIN_TYPE: 0 | 1
    }[]>,
    GetDomainHosts({ domain }: {
        domain: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{
        KLHST_WKS_HOSTNAME: string,
        KLHST_WKS_WINHOSTNAME: string,
        /**
         * 0x00000001 - The computer is online ('visible').
         * 0x00000002 - The computer is added to the administration group.
         * 0x00000004 - The computer has Network Agent installed.
         * 0x00000008 - Network Agent is working.
         * 0x00000010 - The computer has the real-time protection (RTOP).
         * 0x00000020 - The computer has been temporarily switched to the server as a result of switching an NLA profile.
         * 0x00000040 - The computer is part of the cluster or cluster array.
         * 0x00000080 - Appliance.
         */
        KLHST_WKS_STATUS: number
    }[]>,
    FindHostsAsync({ wstrFilter, vecFieldsToReturn, vecFieldsToOrder, pParams, lMaxLifeTime }: {
        wstrFilter?: string,
        vecFieldsToReturn?: string[],
        vecFieldsToOrder?: VecFieldToOrder[],
        pParams?: ExtraOptions,
        lMaxLifeTime?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    FindHostsAsyncGetAccessor({ strRequestId }: {
        strRequestId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<OpenAPIIterator>,
    GetInstanceStatistics({ vecFilterFields }: {
        vecFilterFields: (keyof ServerStats)[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<ServerStats>,
    AddHostsForSync({ pHostNames, strSSType }: {
        pHostNames: Array<string>,
        strSSType: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    GetComponentsForProductOnHost({ strHostName, strProductName, strProductVersion }: {
        strHostName: string,
        strProductName: string,
        strProductVersion: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{
        KLHST_PRCST_COMPONENT_DN: string,
        KLHST_PRCST_COMPONENT_ID: {
            type: string,
            value: string
        },
        KLHST_PRCST_COMPONENT_STATUS: number,
        KLHST_PRCST_COMPONENT_VERSION: {
            type: string,
            value: string
        }
    }[]>,
    UpdateHostsMultiple({ pArrHostIds, pProperties }: {
        pArrHostIds: string[],
        pProperties: Partial<GroupAttributes>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number[]>,
    FindIncidents({ strFilter, pFieldsToReturn, pFieldsToOrder, lMaxLifeTime }: {
        strFilter: string,
        pFieldsToReturn: (keyof IncidentsAttributes)[],
        pFieldsToOrder?: VecFieldToOrder[],
        lMaxLifeTime?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<IncidentIterator>,
    AddIncident({ pData }: {
        pData: Pick<IncidentsAttributes, 'KLINCDT_SEVERITY' | 'KLINCDT_ADDED' | 'KLINCDT_BODY' | 'KLHST_WKS_HOSTNAME'>
            & Partial<Pick<IncidentsAttributes, 'KLHSTUSER_ID'>>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    DeleteIncident({ nId }: {
        nId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    UpdateIncident({ nId, pData }: {
        nId: number,
        pData: Partial<Pick<
            IncidentsAttributes,
            'KLHST_WKS_HOSTNAME' | 'KLINCDT_BODY' | 'KLINCDT_SEVERITY' | 'KLINCDT_ADDED' | 'KLINCDT_IS_HANDLED'>>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}
