import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = HostMoveRules;

type HostMovingAttributes = {
    KLHST_MR_ID: number,
    KLHST_MR_Group: number,
    KLHST_MR_DN: string,
    KLHST_MR_Enabled?: boolean,
    KLHST_MR_AutoDelete?: boolean,
    /**
     *  0 - Rule affects each filtered host once.
     *  1 - Rule affects each filtered host's Network Agent once.
     *  2 - Rule affects each filtered host permanently. Filtered hosts will be 'glued' to the destination group.
     */
    KLHST_MR_Options: 0 | 1 | 2,
    /**
     * 0 - Custom rule defined by the 'KLHST_MR_Query' string (default). See Format of the KLHST_MR_Custom container of host for moving rules created by Administration Console.
     * 1 - Legacy rule automatically created while upgrading Administration Server from the pre-6MP2 version. See Format of the KLHST_MR_Custom host moving rule container for legacy rules.
     * 2 - Rule created indirectly by the remote installation task for automatically moving hosts after remote installation. See Format of the KLHST_MR_Custom container of the host moving rules associated with remote deployment.
     * 3 - Rule created by a user's custom script by using the 'Kaspersky Administration Kit Automation'. The contents of KLHST_MR_Custom are undefined.
     */
    KLHST_MR_Type?: 0 | 1 | 2 | 3,
    KLHST_MR_Query: string,
    KLHST_MR_Custom?: Record<string, any>,
    KLHST_MR_SPECIAL?: {
        KLHST_MR_SPECIAL_AD?: {
            KLHST_MR_SPECIAL_AD_MOVE_TO_SUBGROUPS: boolean,
            KLHST_MR_SPECIAL_AD_CREATE_SUBGROUPS: boolean,
            KLHST_MR_SPECIAL_AD_DELETE_SUBGROUPS: boolean,
            KLHST_MR_SPECIAL_AD_OUID: number
        },
        KLHST_MR_SPECIAL_PCLOUD?: {
            KLHST_MR_SPECIAL_PCLOUD_MOVE_TO_SUBGROUPS: boolean,
            KLHST_MR_SPECIAL_PCLOUD_CREATE_SUBGROUPS: boolean,
            KLHST_MR_SPECIAL_PCLOUD_DELETE_SUBGROUPS: boolean,
            KLHST_MR_SPECIAL_PCLOUD_ID: string
        }
    }
}

type HostMoveRules = BaseOpenAPIClient & {
    GetRules({ pFields }: {
        pFields: string[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<HostMovingAttributes[]>,
    AddRule({ pRuleInfo }: {
        pRuleInfo: Omit<HostMovingAttributes, 'KLHST_MR_ID'>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    GetRule({ nRule }: {
        nRule: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<HostMovingAttributes>,
    DeleteRule({ nRule }: {
        nRule: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    SetRulesOrder({ pRules }: {
        pRules: number[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    UpdateRule({ nRule, pRuleInfo }: {
        nRule: number,
        pRuleInfo: HostMovingAttributes
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    ExecuteRulesNow({ nGroupId, pRules, nOptions }: {
        nGroupId: number,
        pRules: number[],
        nOptions: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}
