import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = HostTagsRulesApi;

type HostAutomaticTaggingRule = {
    KLHST_HTR_DN: string,
    KLHST_HTR_Enabled?: boolean,
    KLHST_HTR_TagValue?: string,
    KLHST_HTR_Query?: string,
    KLHST_HTR_Custom?: string
}

type HostTagsRulesApi = BaseOpenAPIClient & {
    GetRules({ pFields2ReturnArray }: {
        pFields2ReturnArray: (keyof HostAutomaticTaggingRule)[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{
        KLHST_HTR_Rules: Partial<HostAutomaticTaggingRule>[]
    }>,
    UpdateRule({ szwTagValue, pRuleInfo }: {
        szwTagValue: string,
        pRuleInfo: HostAutomaticTaggingRule
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    DeleteRule({ szwTagValue }: {
        szwTagValue: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    ExecuteRule({ szwTagValue }: {
        szwTagValue: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>
}
