import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { TaskEventFilterAttributes } from '../../additional/TaskEventFilterAttributes'
import { TaskData } from '../../data/task'
import BaseOpenAPIClient = require('../base-open-api-client')

export = HostTasks;
type HostTasks = BaseOpenAPIClient & {
    ResetTasksIterator({ strSrvObjId, strProductName, strVersion, strComponentName, strInstanceId, strTaskName }: {
        strSrvObjId: string,
        strProductName?: string,
        strVersion?: string,
        strComponentName?: string,
        strInstanceId?: string,
        strTaskName?: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    AddTask({ strSrvObjId, taskData, skipSerialization }: {
        strSrvObjId: string,
        taskData: Partial<TaskData>,
        skipSerialization?: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    GetNextTask({ strSrvObjId }: {
        strSrvObjId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<TaskData>,
    GetTaskData({ strSrvObjId, strTask }: {
        strSrvObjId: string,
        strTask: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<TaskData>,
    UpdateTask({ strSrvObjId, strTask, pData }: {
        strSrvObjId: string,
        strTask: string,
        pData: Partial<TaskData>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetTaskStartEvent ({ strTask }: {
        strSrvObjId: string,
        strTask: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<TaskEventFilterAttributes>,
    SetTaskStartEvent ({ strSrvObjId, taskId, startEventData, skipSerialization }: {
        taskId: string,
        strSrvObjId: string,
        startEventData: TaskEventFilterAttributes,
        skipSerialization?: boolean,
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    DeleteTask({ strSrvObjId, strTask }: {
        strSrvObjId: string,
        strTask: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetHostTasks({ strHostName }: {
        strHostName: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{
        tasks: TaskData[]
    }>
}
