import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = HostTagsApi;
type HostTagsApi = BaseOpenAPIClient & {
    GetHostTags({ szwHostId, pParams }: {
        szwHostId: string,
        pParams: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{
        KLHST_TagValue: string,
        KLHST_IS_TAG_SET_BY_PRODUCT: boolean,
        KLHST_IS_TAG_SET_BY_HOSTTAGRULE: boolean
    }[]>
}
