import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { ObjectTypes, OpenAPIIterator, ParamValue } from '../../data/common'
import BaseOpenAPIClient = require('../base-open-api-client');

export = HstAccessControl;

type RoleProducts = Record<string, Record<string, {
    role_perm_allowed: unknown,
    role_perm_denied: unknown
}>>

type HstAccessControl = BaseOpenAPIClient & {
    AddRole({ KLHST_ACL_ROLE_DN, role_products }: {
        KLHST_ACL_ROLE_DN: string,
        role_products: RoleProducts
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{
        KLHST_ACL_ROLE_DN: string,
        KLHST_ACL_ROLE_ID: number,
        KLHST_ACL_ROLE_NAME: string
    }>,
    GetRole({ nId, pFieldsToReturn }: {
        nId: number,
        pFieldsToReturn: Array<string>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    DeleteRole({ nId, bProtection }: {
        nId: number,
        bProtection?: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    UpdateRole({ KLHST_ACL_ROLE_NAME, KLHST_ACL_ROLE_ID, displayName, role_products, bProtection }: {
        KLHST_ACL_ROLE_ID: number,
        KLHST_ACL_ROLE_NAME: string,
        displayName: string,
        role_products: RoleProducts,
        bProtection?: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    FindRoles({ filters, fields, sort }: {
        filters: string,
        fields: Array<string>,
        sort?:Array<Record<string, unknown>>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<OpenAPIIterator>,
    FindRolesExtended({ filters, fields, sort, nStart, nEnd }: {
        filters: string,
        fields: Array<string>,
        sort?:Array<Record<string, unknown>>,
        nStart?: number,
        nEnd?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    GetScObjectAcl({ nObjId, nObjType }: {
        nObjId: number,
        nObjType?: ObjectTypes
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    SetScObjectAcl({ nObjId, nObjType, pAclParams, bCheckCurrentUserAce }: {
        nObjId: number,
        nObjType?: ObjectTypes,
        pAclParams: Record<string, unknown>,
        bCheckCurrentUserAce?: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    GetVisualViewForAccessRights({ wstrLangCode, nObjId, nObjType }: {
        wstrLangCode: string,
        nObjId: number,
        nObjType?: ObjectTypes
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    FindTrustees({ filters, fields, sort }: {
        filters: string,
        fields: Array<string>,
        sort?: Array<Record<string, unknown>>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    FindTrusteesExtended({ filters, fields, sort, nStart, nEnd }: {
        filters: string,
        fields: Array<string>,
        sort?: Array<Record<string, unknown>>,
        nStart?: number,
        nEnd?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    GetScVServerAcl({ nId }: {
        nId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    SetScVServerAcl({ nId, pAclParams, bCheckCurrentUserAce }: {
        nId: number,
        pAclParams: Record<string, unknown>,
        bCheckCurrentUserAce?: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    GetAccessibleFuncAreas({ lGroupId, dwAccessMask, szwProduct, szwVersion, bInvert }: {
        lGroupId: number,
        dwAccessMask: number,
        szwProduct: string,
        szwVersion: string,
        bInvert: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string[]>,
    GetUnAccessibleFuncAreas({ lGroupId, szwProduct, szwVersion }: {
        lGroupId: number,
        szwProduct: string,
        szwVersion: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string[]>,
    AccessCheckToAdmGroup({ lGroupId, dwAccessMask, szwFuncArea, szwProduct, szwVersion }: {
        lGroupId: number,
        dwAccessMask: number,
        szwFuncArea: string,
        szwProduct: string,
        szwVersion: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    GetMappingFuncAreaToTasks({ szwProduct, szwVersion }: {
        szwProduct: string,
        szwVersion: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    GetPolicyReadonlyNodes({ lGroupId, szwProduct, szwVersion, szwSectionName, pPolicySection }: {
        lGroupId: number,
        szwProduct: string,
        szwVersion: string,
        szwSectionName: string,
        pPolicySection: Record<string, ParamValue | ParamValue[]>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, string[]>>,
    GetSettingsReadonlyNodes({ lGroupId, szwProduct, szwVersion, szwSectionName, pSettingsSection }: {
        lGroupId: number,
        szwProduct: string,
        szwVersion: string,
        szwSectionName: string,
        pSettingsSection: Record<string, ParamValue | ParamValue[]>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, string[]>>,
    IsTaskTypeReadonly({ lGroupId, szwProduct, szwVersion, szwTaskTypeName }: {
        lGroupId: number,
        szwProduct: string,
        szwVersion: string,
        szwTaskTypeName: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    CheckEffectiveRights({ nVServerId, llTrusteeId, szwProduct, szwVersion, pAccessRights }: {
        nVServerId: number,
        llTrusteeId: number,
        szwProduct: string,
        szwVersion: string,
        pAccessRights: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>
}
