import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = HWInvStorage;

type HWObject = {
    Id: number,
    Type: number,
    SubType: number,
    Created: string,
    LastVisible: string,
    IsWrittenOff: boolean,
    WriteOffDate: boolean,
    InvNum: string,
    UserName: string,
    Placement: string,
    Price: number,
    PurchaseDate: string,
    Corporative: boolean,
    Name: string,
    Description: string,
    Manufacturer: string,
    SerialNumber: string,
    CPU: string,
    MemorySize: number,
    DiskSize: number,
    MotherBoard: string,
    VidPid: string,
    Capacity: number,
    Mac: string,
    StrMac: string,
    OS: string,
    AdObject: string,
    AdObjectDN: string,
    DynColumns:	any[],
    DynColId: string,
    DynColName: string,
    DynColData: string
}

type ProcessingRules = {
    AutoCorporativeByType: number[]
}

type HWInvStorage = BaseOpenAPIClient & {
    GetHWInvObject({ nObjId }: {
        nObjId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<HWObject>,
    SetHWInvObject({ nObjId, pObj }: {
        nObjId: number,
        pObj: Partial<HWObject>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    EnumDynColumns(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{
        DynColId: string,
        DynColName: string
    }[]>,
    AddHWInvObject({ pObj }: {
        pObj: Partial<HWObject>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    DelHWInvObject2({ arrObjId }: {
        arrObjId: Partial<HWObject>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    AddDynColumn({ wstrColName }: {
        wstrColName: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    DelDynColumn({ wstrColId }: {
        wstrColId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetProcessingRules(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<ProcessingRules>,
    SetProcessingRules({ pRules }: {
        pRules: ProcessingRules
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}
