import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { KscCertificate } from '../../data/user';
import BaseOpenAPIClient = require('../base-open-api-client');

export = IWebSrvSettings;

type CertificateInfo = {
    CERT_TYPE: 0 | 1, // 0 - PEM form, 1 - PKCS12 form
    CERT_PUBLIC_PART: KscCertificate
}

type IWebSrvSettings = BaseOpenAPIClient & {
    GetCertificateInfo(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<CertificateInfo>,
    SetCustomCertificate(params: { pCertData: CertificateInfo }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}
