import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = InvLicenseProducts;

enum ProductTypes {
    COMMON = 0,
    FLOATING = 1
}
type LicProducts = {
    KLINVLIC_LIC_PRODUCTS_ARRAY: {
        KLINVLIC_ID: number,
        KLINVLIC_DATA: {
            KLINVLIC_NAME: string,
            KLINVLIC_ACTIVE: boolean,
            KLINVLIC_TYPE: ProductTypes,
            KLINVLIC_DESC: string,
            KLINVLIC_MASKS: string[],
            KLINVLIC_LIKEYS: number[]
        },
    }[]
}
type InvLicenseProducts = BaseOpenAPIClient & {
    GetLicenseProducts({ pParams } : {
        pParams: { KLINVLIC_LIC_PRODUCT_IDS_ARRAY: number[] } | null
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<LicProducts>
}
