import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = InventoryApi;

type CleanerInitializationFile = {
    'INIFILE_PRODUCT_NAME': string,
    'INIFILE_TYPE': 'uninstall' | 'detect-only',
    'INIFILE_FILE_NAME': string
}

type InvList = {
    KLEVP_EA_PARAM_1: {
        PatchID: string,
        bIsMsi: boolean,
        ParentID: string,
        DisplayName: string,
        DisplayVersion: string,
        Publisher: string,
        InstallDate: string,
        Comments: string,
        HelpLink: string,
        HelpTelephone: string,
        Classification: string,
        MoreInfoURL: string,
        UninstallString: string,
        QuietUninstallString: string
    }[]
}

type InventoryApi = BaseOpenAPIClient & {
    GetSrvCompetitorIniFileInfoList({ wstrType }: {
        wstrType: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<CleanerInitializationFile[]>,
    GetInvProductsList(pParams: Record<string, unknown>, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<InvList>,
    GetInvPatchesList(pParams: Record<string, unknown>, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<InvList>,
    GetObservedApps(params: Record<string, unknown>, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Array<string>>,
    SetObservedApps(params: {
        pAppIds: Array<string>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    DeleteUninstalledApps(params: Record<string, unknown>, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetHostInvProducts({ szwHostId }: {
        szwHostId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<InvList>,
    GetHostInvPatches({ szwHostId }: {
        szwHostId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<InvList>
}
