import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = KeyService;
type KeyService = BaseOpenAPIClient & {
    DecryptData({ pEncryptedData, wstrProdName, wstrProdVersion }: {
        pEncryptedData: string,
        wstrProdName: string,
        wstrProdVersion: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    EncryptData({ pData }: {
        pData: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    EncryptDataForHost({ wstrHostId, pData }: {
        wstrHostId: string,
        pData: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>
}
