import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = KLEVerControl;
type KLEVerControl = BaseOpenAPIClient & {
    ChangeCreatePackage({ vecDistribLocIdsToCreate, vecDistribLocIdsNotToCreate }: {
        vecDistribLocIdsToCreate?: number[],
        vecDistribLocIdsNotToCreate?: number[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    DownloadDistributiveAsync({ lDistribLocId }: {
        lDistribLocId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetDownloadDistributiveResult({ wstrRequestId }: {
        wstrRequestId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>
}
