import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { ParamBinary, ParamParams } from '../../data/common'
import BaseOpenAPIClient = require('../base-open-api-client');

export = KsnInternal;

type NKsnEulaParams = {
    NKsnEula: string,
    NKsnEulaLoc: string,
    NKsnProviderLoc: string,
    NKsnProviderName: string,
    NKsnProviderContacts: string,
    NKsnCreateTime: string
}

type KsnProxySettings = {
    KSNPROXY_ENABLE: boolean,
    KSNPROXY_KSN_TYPE: 1 | 2,
    KSNPROXY_NKSN_SETTINGS: ParamBinary,
    KSNPROXY_TCP_PORT: number,
    KSNPROXY_UDP_PORT: number,
    KSNPROXY_MAX_REC_COUNT: number,
    KSNPROXY_ENABLE_PATCH_MAN_STA: boolean,
    KSNPROXY_USE_MASTER_KSNPROXY_AS_KSN: boolean
}

type KsnInternal = BaseOpenAPIClient & {
    VerifyNKsnSettings({ pSettings }: {
        pSettings: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    VerifyKpsnConfigLoc({ pKpsnConfigPkcs7, wstrLoc }: {
        pKpsnConfigPkcs7: string,
        wstrLoc: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    GetNKsnEula({ wstrNKsnLoc }: {
        wstrNKsnLoc: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Pick<NKsnEulaParams, 'NKsnEula' | 'NKsnEulaLoc'>>,
    GetNKsnEulas(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{ pNKsnEulas: Array<ParamParams<NKsnEulaParams>> }>,
    CheckKsnConnection(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    GetSettings(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<KsnProxySettings>,
    SendKsnStatistics({ wstrStatName, pStatBody }: {
        wstrStatName: string,
        pStatBody: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    NeedToSendStatistics(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>
}
