import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client')

export = LicenseInfoSync;
type LicenseInfoSync = BaseOpenAPIClient & {
    AcquireKeysForProductOnHost({ szwHostName, szwProduct, szwVersion }: {
        szwHostName: string,
        szwProduct: string,
        szwVersion: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown | {
        result: unknown
    }>,
    AcquireKeysForProductOnHost2({ szwHostName, szwProduct, szwVersion }: {
        szwHostName: string,
        szwProduct: string,
        szwVersion: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown | {
        result: unknown
    }>,
    GetKeyDataForHost({ szwHostName, szwProduct, szwVersion, szwSerial }: {
        szwHostName: string,
        szwProduct: string,
        szwVersion: string,
        szwSerial: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    IsLicForSaasValid2({ pKeyInfo, bAsCurrent }: {
        pKeyInfo: Record<string, unknown>,
        bAsCurrent: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    IsPCloudKey({ nProductId }: {
        nProductId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    IsPCloudKey2({ pKeyInfo }: {
        pKeyInfo: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    SynchronizeLicInfo2(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    TryToInstallLicForSaas2({ pKeyInfo, bAsCurrent }: {
        pKeyInfo: Record<string, unknown>,
        bAsCurrent: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    TryToUnistallLicense({ bCurrent }: {
        bCurrent: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}
