import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { LicenseKey, LicenseKeyData } from '../../data/license'
import GroupSyncIterator = require('./group-sync-iterator');

export = LicenseKeys;

type InData = {
    KLLIC_SERIAL: string
}

type LicenseKeys = GroupSyncIterator & {
    AcquireKeyHosts({ pInData, pFields, pFieldsToOrder, pOptions, lTimeoutSec }: {
        pInData: InData,
        pFields: Array<keyof LicenseKey>,
        pFieldsToOrder: Array<keyof LicenseKey>,
        pOptions: Record<string, unknown>,
        lTimeoutSec?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    AdjustKey({ pData }: {
        pData: InData & {
            KLLICSRV_AUTOKEY: boolean | 'true' | 'false'
        }
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    CheckIfSaasLicenseIsValid({ pInData, bAsCurrent }: {
        pInData: InData,
        bAsCurrent?: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    EnumKeys({ pFields, pFieldsToOrder, pOptions, lTimeoutSec }: {
        pFields: Array<keyof LicenseKey>,
        pFieldsToOrder?: Array<keyof LicenseKey>,
        pOptions?: { KLLICSRV_ENOPT_INSTALLED_ONLY?: true },
        lTimeoutSec?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<LicenseKeyData[]>,
    GetKeyData({ pKeyInfo }: {
        pKeyInfo: {
            KLLICSRV_KEYDATA: any
        } | InData
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<LicenseKeyData>,
    InstallKey({ pKeyInfo }: {
        pKeyInfo: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    SaasTryToInstall({ pInData, bAsCurrent }: {
        pInData: InData,
        bAsCurrent: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    SaasTryToUninstall({ bCurrent }: {
        bCurrent: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    UninstallKey({ pKeyInfo }: {
        pKeyInfo: InData
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    DownloadKeyFiles({ wstrActivationCode }: {
        wstrActivationCode: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string[]>
}
