import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = LicensePolicy;
type LicensePolicy = BaseOpenAPIClient & {
    IsLimitedMode({ nFunctionality }: {
        nFunctionality: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    GetTotalLicenseCount({ nFunctionality }: {
        nFunctionality: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    GetFreeLicenseCount({ nFunctionality }: {
        nFunctionality: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    SetLimitedModeTest({ nFunctionality, bLimited }: {
        nFunctionality: number,
        bLimited: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    SetTotalLicenseCountTest({ nFunctionality, nCount }: {
        nFunctionality: number,
        nCount: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    SetUsedLicenseCountTest({ nFunctionality, nCount }: {
        nFunctionality: number,
        nCount: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}
