import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = ListTags;
type ListTags = BaseOpenAPIClient & {
    AddTag({ tagsType, szwTagValue, pParams }: {
        tagsType: string,
        szwTagValue: string,
        pParams: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    DeleteTags2({ tagsType, pTagValue, pParams }: {
        tagsType: string,
        pTagValue: Array<string>,
        pParams: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetAllTags({ tagsType, pParams, deserialize }: {
        tagsType: string,
        pParams: Record<string, unknown>,
        deserialize: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    GetTags({ tagsType, pIdArray, pParams }: {
        tagsType: string,
        pIdArray: Array<unknown>,
        pParams: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    RenameTag({ tagsType, szwOldTagValue, szwNewTagValue, pParams }: {
        tagsType: string,
        szwOldTagValue: string,
        szwNewTagValue: string,
        pParams: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    SetTags({ tagsType, pListItemsTags, pParams }: {
        tagsType: string,
        pListItemsTags: Array<unknown>,
        pParams: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}
