import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { DeviceEnrollmentRecipient, KscCertificate, KscNotification } from '../../data/user'
import { ParamBinary } from '../../data/common'
import BaseOpenAPIClient = require('../base-open-api-client');

export = MdmCertCtrlApi;

/**
 * 0    Unknown
 * 1    User
 * 2    EMail
 * 3    VPN
 */
type NCertType = 0 | 1 | 2 | 3;

type IssuanceSettings = {
    CI_nCertType: NCertType,
    CI_bFeatureActive: boolean,
    CI_bAutorenewalEnabled?: boolean,
    CI_nRenewalPeriodSec?: number,
    CI_bAutoIssuanceDisabled?: boolean,
    CI_wstrPkiCertTemplateName?: string,
    CI_bEncryptionEnabled?: boolean,
    CI_nEncryptionPwdLength?: number,
    CI_nExpiryPeriod?: number
}

type PackageData = {
    Pkg_nId: number,
    Pkg_wstrName: string,
    Pkg_wstrProductName: string,
    Pkg_wstrProductVersion: string,
    Pkg_tmCreationTime: string,
    Pkg_wstrProductDisplayName: string,
    Pkg_wstrProductDisplayVersion: string
}

type PkiTemplate = {
    PKI_TMPL_CN: string,
    PKI_TMPL_DISPLAYNAME: string,
    PKI_TMPL_DISTINGUISGEDNAME: string,
    PKI_TMPL_EKUS: string | string[]
}

type Recipient = Partial<DeviceEnrollmentRecipient> & {
    ul_binId: ParamBinary,
    User_wstrMailAlt?: string,
    User_wstrMobileAlt?: string
}

type MdmCertCtrlApi = BaseOpenAPIClient & {
    CancelGeneratePackage2({ wstrRequestId }: {
        wstrRequestId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    CancelSetCertificate2({ wstrRequestId }: {
        wstrRequestId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    CheckMailNotificationSettings({ bCheckMainServerDefaults }: {
        bCheckMainServerDefaults: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    CheckPkiAccount({ wsAccountName, pAccountPwd }: {
        wsAccountName: string,
        pAccountPwd: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    CheckPkiEnabled(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    DeleteCertificates({ pIds }: {
        pIds: number[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GeneratePackageAsync2({ pPackageInfo, pCertificate, pRecipients, pNotification }: {
        pPackageInfo: {
            GPProtocolId: number,
            GPHostId: string,
            GPMtncSrvId: string,
            GPPkgId: string
        } | {
            GCDevOsType: number
        },
        pCertificate: KscCertificate,
        pRecipients: Recipient[],
        pNotification: Partial<KscNotification>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    GetCertificatePublic({ nCertId }: { nCertId: number }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    GetIssuanceSettings(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<IssuanceSettings[]>,
    GetIssuanceSettingsByType({ nCertType }: { nCertType: NCertType }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<IssuanceSettings>,
    GetPackagesByPackageProduct({ wsPkgProductName, wsPkgProductVersion }: {
        wsPkgProductName: string,
        wsPkgProductVersion: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<PackageData[]>,
    GetPkiTemplates({ bForceReload }: { bForceReload: boolean }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<PkiTemplate[]>,
    GetPkiTemplatesByEKU({ wsEKU, bForceReload }: {
        wsEKU: string,
        bForceReload: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<PkiTemplate[]>,
    GetRestoreData({ wstrDeviceHostName }: { wstrDeviceHostName: string }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    RenewCertificate({ nCertId, pCertificate }: {
        nCertId: number,
        pCertificate: KscCertificate
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    SetCertificateAsync2({ pAuthType, pNotification, pCertificate, pRecipient }: {
        pAuthType?: {
            NSOneTime?: boolean,
            NSDomain?: boolean
        },
        pNotification: Partial<KscNotification>,
        pCertificate: KscCertificate,
        pRecipient: Recipient
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    SetCertificateTag({ nCertId, wstrCertTag }: {
        nCertId: number,
        wstrCertTag: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    UpdateIssuanceSettings({ pCertTypes }: {
        pCertTypes: IssuanceSettings[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}
