import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = MigrationData;
type MigrationData = BaseOpenAPIClient & {
    CancelExport({ wstrActionGuid }: {
        wstrActionGuid: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    Export({ KLMIGR_ROOT_GROUP_ID, KLMIGR_ARR_ID_REPORTS, KLMIGR_ARR_ID_CMN_TASKS, KLMIGR_ARR_ID_EXTRA_QRS, KLMIGR_ARR_PRODUCTS_INFO, KLMIGR_SKIP_CUSTOM_ROLES, KLMIGR_SKIP_USERS_GROUPS, KLMIGR_SKIP_CUSTOM_APP_CATEGORIES }: {
        KLMIGR_ROOT_GROUP_ID: number,
        KLMIGR_ARR_ID_REPORTS: number[],
        KLMIGR_ARR_ID_CMN_TASKS: number[],
        KLMIGR_ARR_ID_EXTRA_QRS: number[],
        KLMIGR_ARR_PRODUCTS_INFO: {
            KLMIGR_PRODUCT_INFO_NAME: string,
            KLMIGR_PRODUCT_INFO_VERSION: string
        }[],
        KLMIGR_SKIP_CUSTOM_ROLES: boolean,
        KLMIGR_SKIP_USERS_GROUPS: boolean,
        KLMIGR_SKIP_CUSTOM_APP_CATEGORIES: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string>>,
    Import({ wstrUrl, pOptions }: {
        wstrUrl: string,
        pOptions: {
            KLMIGR_ROOT_GROUP_ID: number
        }
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    InitFileUpload(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    AcquireKnownProducts(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<ProductEntry[]>
}

type ProductEntry = {
    KLMIGR_PRODUCT_INFO_NAME: string,
    KLMIGR_PRODUCT_INFO_VERSION: string,
    KLMIGR_PRODUCT_INFO_DN: string
}
