import { ApiResponsePromise } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = NagHstCtl;
type NagHstCtl = BaseOpenAPIClient & {
    GetHostRuntimeInfo({ pFilter, connectionId }: {
        pFilter: Record<string, unknown>,
        connectionId: string
    }): ApiResponsePromise<unknown>,
    SendProductAction({ szwProduct, szwVersion, nProductAction, connectionId }: {
        szwProduct: string,
        szwVersion: string,
        nProductAction: number,
        connectionId: string
    }): ApiResponsePromise<void>,
    SendTaskAction({ szwProduct, szwVersion, szwTaskStorageId, nTaskAction, connectionId }: {
        szwProduct: string,
        szwVersion: string,
        szwTaskStorageId: string,
        nTaskAction: number,
        connectionId: string
    }): ApiResponsePromise<void>
}
