import { ApiResponsePromise } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = NagNetworkListApi;

type NagNetworkListParams = {
    listName: string,
    itemId: string,
    bNeedPacked: boolean,
    connectionId: string
}

type NagNetworkExtraParams = {
    productName: string,
    productVersion: string,
    ulStartPos: number,
    lBytesToRead: number
}

type NagNetworkListApi = BaseOpenAPIClient & {
    GetListItemFileInfo(params: NagNetworkListParams): ApiResponsePromise<number>,
    GetListItemFileInfo2(params:NagNetworkListParams & Pick<NagNetworkExtraParams, 'productName' | 'productVersion'>): ApiResponsePromise<number>,
    GetListItemFileChunk(params: NagNetworkListParams & Pick<NagNetworkExtraParams, 'ulStartPos' | 'lBytesToRead'>): ApiResponsePromise<number>,
    GetListItemFileChunk2(params: NagNetworkListParams & NagNetworkExtraParams): ApiResponsePromise<number>
}
