import { ApiResponsePromise } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = NagRdu;
type NagRdu = BaseOpenAPIClient & {
    ChangeTraceParams({ szwProductID, nTraceLevel, connectionId }: {
        szwProductID: string,
        nTraceLevel: number,
        connectionId: string
    }): ApiResponsePromise<unknown>,
    ChangeTraceRotatedParams({ szwProductID, nTraceLevel, nPartsCount, nMaxPartSize, connectionId }: {
        szwProductID: string,
        nTraceLevel: number,
        nPartsCount: number,
        nMaxPartSize: number,
        connectionId: string
    }): ApiResponsePromise<unknown>,
    ChangeXperfBaseParams({ szwProductID, nTraceLevel, nXPerfMode, connectionId }: {
        szwProductID: string,
        nTraceLevel: number,
        nXPerfMode: number,
        connectionId: string
    }): ApiResponsePromise<unknown>,
    ChangeXperfRotatedParams({ szwProductID, nTraceLevel, nXPerfMode, nMaxPartSize, connectionId }: {
        szwProductID: string,
        nTraceLevel: number,
        nXPerfMode: number,
        nMaxPartSize: number,
        connectionId: string
    }): ApiResponsePromise<unknown>,
    CreateAndDownloadDumpAsync({ szwProcessName, connectionId }: {
        szwProcessName: string,
        connectionId: string
    }): ApiResponsePromise<string>,
    DeleteFile({ szwRemoteFile, connectionId }: {
        szwRemoteFile: string,
        connectionId: string
    }): ApiResponsePromise<unknown>,
    DeleteFiles({ pRemoteFiles, connectionId }: {
        pRemoteFiles: Record<string, unknown>,
        connectionId: string
    }): ApiResponsePromise<unknown>,
    DownloadCommonDataAsync({ connectionId }: {
        connectionId: string
    }): ApiResponsePromise<string>,
    DownloadEventlogAsync({ szwEventLog, connectionId }: {
        szwEventLog: string,
        connectionId: string
    }): ApiResponsePromise<string>,
    ExecuteFileAsync({ szwURL, szwShortExecName, szwParams, connectionId }: {
        szwURL: string,
        szwShortExecName: string,
        szwParams: string,
        connectionId: string
    }): ApiResponsePromise<string>,
    ExecuteGsiAsync({ connectionId }: {
        connectionId: string
    }): ApiResponsePromise<string>,
    GetCurrentHostState({ connectionId }: {
        connectionId: string
    }): ApiResponsePromise<unknown>,
    GetUrlToDownloadFileFromHost({ szwRemoteFile, connectionId }: {
        szwRemoteFile: string,
        connectionId: string
    }): ApiResponsePromise<string>,
    GetUrlToUploadFileToHost({ connectionId }: {
        connectionId: string
    }): ApiResponsePromise<string>,
    RunKlnagchkAsync({ szwProductID, connectionId }: {
        szwProductID: string,
        connectionId: string
    }): ApiResponsePromise<string>,
    SetProductStateAsync({ szwProductID, nNewState, connectionId }: {
        szwProductID: string,
        nNewState: number,
        connectionId: string
    }): ApiResponsePromise<string>
}
