import { ApiResponsePromise } from '../../types'
import { RemoteScreenType } from '../../constants/RemoteScreenType';
import { RemoteScreenSessionInfo } from '../../additional/RemoteScreenSessionInfo'
import BaseOpenAPIClient = require('../base-open-api-client');

export = NagRemoteScreen;
type NagRemoteScreen = BaseOpenAPIClient & {
    GetExistingSessions({ nType, connectionId }: {
        nType: RemoteScreenType,
        connectionId: string
    }): ApiResponsePromise<RemoteScreenSessionInfo[]>,
    OpenSession({ nType, szwID, connectionId }: {
        nType: RemoteScreenType,
        szwID: string,
        connectionId: string
    }): ApiResponsePromise<unknown>,
    CloseSession({ pSharingHandle, connectionId }: {
        pSharingHandle: Record<string, unknown>,
        connectionId: string
    }): ApiResponsePromise<void>,
    GetDataForTunnel({ pSharingHandle, connectionId }: {
        pSharingHandle: Record<string, unknown>,
        connectionId: string
    }): ApiResponsePromise<unknown>,
    GetWdsData({ pSharingHandle, nLocalPortNumber, connectionId }: {
        pSharingHandle: Record<string, unknown>,
        nLocalPortNumber: number,
        connectionId: string
    }): ApiResponsePromise<unknown>
}
