import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = NlaDefinedNetworks;
type NlaDefinedNetworks = BaseOpenAPIClient & {
    AddNetwork({ wstrNetworkName }: {
        wstrNetworkName: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    DeleteNetwork({ nNetworkId }: {
        nNetworkId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetNetworkInfo({ nNetworkId }: {
        nNetworkId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    GetNetworksList(data: Record<string, unknown>, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Array<Record<string, unknown>>>,
    SetNetworkInfo({ pNetwork }: {
        pNetwork: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}
