import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = OAuth2;

type OAuth2ClientAttributes = {
    KLOAUTH2_CLIENT_INT_ID: number,
    KLOAUTH2_CLIENT_HOST_ID: string,
    KLOAUTH2_CLIENT_PROD_NAME: string,
    KLOAUTH2_CLIENT_PROD_VERSION: string,
    KLOAUTH2_CLIENT_ID: string,
    KLOAUTH2_CLIENT_SECRET: string,
    KLOAUTH2_CLIENT_SETTINGS: {
        OAUTH2_CLIENT_SCOPE?: unknown
    },
    KLOAUTH2_CLIENT_STATE: number
}

type OAuth2ResourceServerAttributes = {
    KLOAUTH2_RESSERVER_INT_ID: number,
    KLOAUTH2_RESSERVER_HOST_ID: string,
    KLOAUTH2_RESSERVER_PROD_NAME: string,
    KLOAUTH2_RESSERVER_PROD_VERSION: string,
    KLOAUTH2_RESSERVER_AUTH_CERT: string,
    KLOAUTH2_RESSERVER_AUTH_KEY: string,
    KLOAUTH2_RESSERVER_AUTH_KEY_PWD: string,
    KLOAUTH2_RESSERVER_SETTINGS: string,
    KLOAUTH2_RESSERVER_STATE: number
}

type OAuth2WriteOnlyServerAttrs = 'KLOAUTH2_RESSERVER_AUTH_KEY' | 'KLOAUTH2_RESSERVER_AUTH_KEY_PWD';

type OAuth2 = BaseOpenAPIClient & {
    GetClients({ nFilterByState }: {
        nFilterByState: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<OAuth2ClientAttributes[]>,
    GetNewClients(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<OAuth2ClientAttributes[]>,
    GetClientsToRegistration(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<OAuth2ClientAttributes[]>,
    ApproveNewClients({ pClients }: {
        pClients: Partial<OAuth2ClientAttributes>[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    DeclineNewClients({ pClientIds }: {
        pClientIds: number[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetResServers({ nFilterByState }: {
        nFilterByState: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Omit<OAuth2ResourceServerAttributes, OAuth2WriteOnlyServerAttrs>[]>,
    GetNewResServers(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Omit<OAuth2ResourceServerAttributes, OAuth2WriteOnlyServerAttrs>[]>,
    ApproveNewResServers({ pResServers }: {
        pResServers: Partial<OAuth2WriteOnlyServerAttrs>[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    DeclineNewResServers({ pResServerIds }: {
        pResServerIds: number[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}
