import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { PackageAttributes } from '../../data/package'
import BaseOpenAPIClient = require('../base-open-api-client');

export = PackagesApi;

type PackageIdParam = {
    nPackageId: number
}

type PackageDataParam = {
    wstrPackageName: string,
    wstrFolder: string,
    wstrProductName: string,
    wstrProductVersion: string,
    wstrProductDisplName: string,
    wstrProductDisplVersion: string
}

type PackageStorageParam = {
    wstrStorageDescr: string,
    wstrName: string,
    wstrVersion: string,
    nTimeoutMsec?: number
}

type AdditionalParameters = {
    KLPKG_NAME?: string,
    KLPKG_FILE?: string,
    KLPKG_FILE_PARAMS?: string
}

type UserAgreement = {
    nEulaDbId: number,
    nAgreementType: number,
    strEULA: string,
    KLPKG_LANG_TAG: string,
    bEulaAccepted: boolean,
    nLCID: number
}

type IncompatibleAppsInfo = {
    'KLPKG_GIAI_RESULT': boolean,
    'KLPKG_GIAI_INFO': {
        'KLPKG_IncompatibleAppInfoType': number,
        'KLPKG_IncompatibleAppInfoPlainText': string
    },
    'KLPKG_GIAI_CAN_REMOVE_BY_INSTALLER': boolean,
    'KLPKG_GIAI_REMOVE_BY_INSTALLER': boolean
}

type PackagesApi = BaseOpenAPIClient & {
    GetUserAgreements(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Array<UserAgreement>>,
    GetEulaText({ nEulaId }: {
        nEulaId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    AcceptEulas({ vecEulaIDs }: {
        vecEulaIDs?: number[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetPackages2(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Array<PackageAttributes>>,
    GetPackages(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Array<PackageAttributes>>,
    DeleteExecutablePkg(params: PackageIdParam, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    RemovePackage(params: PackageIdParam, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    RemovePackage2(params: PackageIdParam, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    GetPackageInfo2({ nPackageId, skipDeserialize }: {
        nPackageId: number,
        skipDeserialize?: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<PackageAttributes>,
    GetPackageInfo(params: PackageIdParam, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<PackageAttributes>,
    SS_GetNames(params: PackageStorageParam, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string[]>,
    SS_Read(params: PackageStorageParam & {
        wstrSection: string,
        skipDeserialize?: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    SS_Write(params: PackageStorageParam & {
        wstrSection: string,
        pData: Record<string, unknown>,
        nOperationType?: number,
        skipSerialize?: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    SS_SectionOperation(params: PackageStorageParam & {
        wstrSection: string,
        nOperationType?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    RenamePackage({ nPackageId, wstrNewPackageName }: {
        nPackageId: number,
        wstrNewPackageName: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetIncompatibleAppsInfo(params: PackageIdParam, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<IncompatibleAppsInfo>,
    SetRemoveIncompatibleApps({ nPackageId, bRemoveIncompatibleApps }: {
        nPackageId: number,
        bRemoveIncompatibleApps?: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    ReadPkgCfgFile({ nPackageId, wstrFileName }: {
        nPackageId: number,
        wstrFileName: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    WritePkgCfgFile({ nPackageId, wstrFileName, pData }: {
        nPackageId: number,
        wstrFileName: string,
        pData: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    UpdateBasesInPackagesAsync({ pParams }: {
        pParams: {
            KLTSK_RI_PACKAGES_IDS: Array<number>
        }
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    CancelUpdateBasesInPackages({ wstrRequestId }: {
        wstrRequestId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    SetLicenseKey({ nPackageId, wstrKeyFileName, pData, bRemoveExisting }: {
        nPackageId: number,
        wstrKeyFileName: string,
        pData: string,
        bRemoveExisting: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetLicenseKey(params: PackageIdParam, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    GetExecutablePackages(params: PackageIdParam, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Array<unknown>>,
    PublishStandalonePackage({ bPublish, nPkgExecId }: {
        bPublish: boolean,
        nPkgExecId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    AddExtendedSign(params: PackageIdParam, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    AddExtendedSignAsync({ pParams, wstrRequestID }: {
        pParams: Record<string, unknown>,
        wstrRequestID: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    AllowSharedPrerequisitesInstallation({ nPackageId, bAllow }: {
        nPackageId: number,
        bAllow: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    CancelCreateExecutablePkg({ wstrRequestId }: {
        wstrRequestId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    CancelGetExecutablePkgFile({ wstrRequestId }: {
        wstrRequestId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    CancelRecordNewPackage({ szwRequestId }: {
        szwRequestId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    CreateExecutablePkgAsync({ pData }: {
        pData: {
            KLTSK_RI_PACKAGES_IDS: number[],
            KLPKG_evpExecPkgId: number,
            KLPKG_NAME: string,
            KLPKG_VIRTUAL: boolean,
            KLTSK_RI_RBT_USE_TSK_SETTINGS: boolean,
            KLTSK_RU_REBOOT_IMMEDIATELY: boolean,
            KLTSK_RU_REBOOT_ASK_FOR_REBOOT: boolean,
            KLTSK_RU_REBOOT_ASK_FOR_REBOOT_PERIOD: number,
            KLTSK_RU_REBOOT_FORCE_REBOOT_PERIOD: number,
            KLTSK_RU_REBOOT_MESSAGE: string,
            KLTSK_RU_FORCE_APPS_CLOSED: boolean,
            KLPKG_EXT_LOC_STRINGS: Record<string, unknown>,
            UseProxy: boolean,
            ProxyServerAddress: string,
            ProxyServerUser: string,
            ProxyServerPassword: string
        }
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    GetExecutablePkgFileAsync({ pParams, nPackageId }: {
        pParams: Record<string, unknown>,
        nPackageId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    GetIntranetFolderForNewPackage({ wstrProductName, wstrProductVersion }: {
        wstrProductName: string,
        wstrProductVersion: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    GetIntranetFolderForPackage(params: PackageIdParam, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    GetKpdProfileString({ nPackageId, wstrSection, wstrKey, wstrDefault }: {
        nPackageId: number,
        wstrSection: string,
        wstrKey: string,
        wstrDefault: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    GetLoginScript({ nPackageId, wstrTaskId }: {
        nPackageId: number,
        wstrTaskId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    GetMoveRuleInfo({ nRuleId }: {
        nRuleId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    GetPackageInfoFromArchive({ wstrFileId, pOptions }: {
        wstrFileId: string,
        pOptions: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    GetRebootOptionsEx(params: PackageIdParam, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    IsPackagePublished({ nPkgExecId }: {
        nPkgExecId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    PrePublishMobilePackage({ wstrProfileId }: {
        wstrProfileId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    PublishMobileManifest({ nPkgExecId, pAppData }: {
        nPkgExecId: number,
        pAppData: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    PublishMobilePackage({ wstrProfileId, pProfileData }: {
        wstrProfileId: string,
        pProfileData: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    ReadKpdFile(params: PackageIdParam, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    RecordNewPackage(data: PackageDataParam, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    RecordNewPackage2(data: Omit<PackageDataParam, 'wstrFolder'> & {
        wstrFileId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    RecordNewPackage3({ wstrFileId, pOptions }: {
        wstrFileId: string,
        pOptions?: AdditionalParameters
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    RecordNewPackage3Async({ wstrFileId, pOptions, wstrRequestID }: {
        wstrFileId: string,
        pOptions?: AdditionalParameters,
        wstrRequestID: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    RecordNewPackageAsync(data: PackageDataParam, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    RecordVapmPackageAsync({ szwNewPackageName, parProductInfo }: {
        szwNewPackageName: string,
        parProductInfo: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    ResetDefaultServerSpecificSettings(params: PackageIdParam, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    ResolvePackageLcid({ nPackageId, nLcid }: {
        nPackageId: number,
        nLcid: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    RetranslateToVServerAsync({ nPackageId, nVServerId, pOptions }: {
        nPackageId: number,
        nVServerId: number,
        pOptions: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    UnpublishMobilePackage({ wstrProfileId }: {
        wstrProfileId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    WriteKpdProfileString({ nPackageId, wstrSection, wstrKey, wstrValue }: {
        nPackageId: number,
        wstrSection: string,
        wstrKey: string,
        wstrValue: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}
