import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = PatchParameters;
type PatchParameters = BaseOpenAPIClient & {
    GetTemplate({ patchID, locID }: {
        patchID: bigint,
        locID: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    SetValues({ patchID, locID, parsValues }: {
        patchID: bigint,
        locID: number,
        parsValues: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    GetValues({ patchID, locID }: {
        patchID: bigint,
        locID: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    SetValuesByPkg({ packageId, parsValues }: {
        packageId: number,
        parsValues: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    GetValuesByPkg({ packageId }: {
        packageId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>
}
