import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = PLCDevApi;
type PLCDevApi = BaseOpenAPIClient & {
    DeletePLC({ pPLCId }: {
        pPLCId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    GetPLC({ pPLCId, parOptions }: {
        pPLCId: string,
        parOptions: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{
        result: unknown
    }>,
    UpdatePLC({ pPLCId, pPLCInfo }: {
        pPLCId: string,
        pPLCInfo: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>
}
