import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

type PluginStorageValue = {
    KLPDS_VALUE: string,
    KLPDS_IS_URL: boolean
}

export = PluginDataStorage;
type PluginDataStorage = BaseOpenAPIClient & {
    EnumAllKeys({ wstrPluginName }: {
        wstrPluginName: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string[]>,
    LoadValues({ wstrPluginName, pArrayOfKeys }: {
        wstrPluginName: string,
        pArrayOfKeys: string[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, PluginStorageValue>>,
    DeleteValue({ wstrPluginName, wstrKey }: {
        wstrPluginName: string,
        wstrKey: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    ReplaceValues({ wstrPluginName, pValues }: {
        wstrPluginName: string,
        pValues: Record<string, number>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    StartUploadValue({ wstrPluginName, nValueSize }: {
        wstrPluginName: string,
        nValueSize: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    FinishUploadValue({ wstrUrl, wstrKey }: {
        wstrUrl: string,
        wstrKey: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetValue({ url }: { url: string }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<PluginStorageValue>
}
