import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = PluginData;
type PluginData = BaseOpenAPIClient & {
    StorePluginData({ wstrPluginName, pData }: {
        wstrPluginName: string,
        pData: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    LoadPluginData({ wstrPluginName }: {
        wstrPluginName: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>
}
