import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = PolicyProfiles;

type PolicyWrapper<T> = {
    KLPRSS_Val: T,
    KLPRSS_Mnd: boolean,
    KLPRSS_ValLck?: boolean,
    KLPRSS_ValLckGroup?: string,
    KLPRSS_ValLckGrpId?: number,
    KLPRSS_ValLckPolId?: number,
    KLPRSS_ValLckPolicy?: string
}

type PolicyProfile = {
    EXPRESSION: PolicyWrapper<[string]>,
    KLSSPOL_PRF_ENABLED: PolicyWrapper<boolean>,
    KLSSPOL_PRF_PROTECTED?: PolicyWrapper<boolean>
}

type PolicyProfiles = BaseOpenAPIClient & {
    EnumProfiles({ nPolicy, nRevision }: {
        nPolicy: number,
        nRevision?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<PolicyProfile[]>,
    GetProfile({ nPolicy, nRevision, szwName }: {
        nPolicy: number,
        nRevision?: number,
        szwName: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<PolicyProfile>,
    GetProfileSettings({ nPolicy, nRevision, szwName, nLifeTime }: {
        nPolicy: number,
        nRevision?: number,
        szwName: string,
        nLifeTime?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    AddProfile({ nPolicy, szwName, pAttrs, nLifeTime }: {
        nPolicy: number,
        szwName: string,
        pAttrs: PolicyProfile,
        nLifeTime?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    DeleteProfile({ nPolicy, szwName }: {
        nPolicy: number,
        szwName: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    UpdateProfile({ nPolicy, szwName, pAttrsToUpdate }: {
        nPolicy: number,
        szwName: string,
        pAttrsToUpdate: PolicyProfile
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetPriorities({ nPolicy, nRevision }: {
        nPolicy: number,
        nRevision?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string[]>,
    PutPriorities({ nPolicy, pArrayOfNames }: {
        nPolicy: number,
        pArrayOfNames: string[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    RenameProfile({ nPolicy, szwExistingName, szwNewName }: {
        nPolicy: number,
        szwExistingName: string,
        szwNewName: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetEffectivePolicyContents({ nPolicy, szwHostId, nLifeTime }: {
        nPolicy: number,
        szwHostId: string,
        nLifeTime?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>
}
