import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { ParamDateTime } from '../../data/common'
import BaseOpenAPIClient = require('../base-open-api-client');

export = Policy;

type PolicyData = {
    KLPOL_ID: number,
    KLPOL_CREATED: ParamDateTime,
    KLPOL_MODIFIED: ParamDateTime,
    KLPOL_FORCED: boolean,
    KLPOL_INHERITED: boolean,
    KLPOL_GSYN_ID: number,
    KLPOL_GROUP_NAME: string,
    KLPOL_PROFILES_NUM: number,

    KLPOL_DN: string,
    KLPOL_PRODUCT: string,
    KLPOL_VERSION: string,
    KLPOL_GROUP_ID: number,
    KLPOL_ACTIVE: boolean, // false by default
    KLPOL_ROAMING: boolean, // false by default
    KLPOL_ACCEPT_PARENT: boolean, // true by default
    KLPOL_FORCE_DISTRIB2CHILDREN: boolean, // false by default
    KLPOL_HIDE_ON_SLAVES: boolean // false by default
}

type OutbreakPolicy = {
    KLPOL_ID: number,
    KLPOL_OUTBREAK_MASK: number
}

type Policy = BaseOpenAPIClient & {
    GetPoliciesForGroup({ nGroupId }: {
        nGroupId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<PolicyData[]>,
    GetPolicyData({ nPolicy }: {
        nPolicy: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<PolicyData>,
    GetPolicyContents({ nPolicy, nRevisionId, nLifeTime }: {
        nPolicy: number,
        nRevisionId?: number,
        nLifeTime?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    AddPolicy(policy: Partial<PolicyData>, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    UpdatePolicyData({ nPolicy, pPolicyData: { KLPOL_DN, KLPOL_ACTIVE, KLPOL_ROAMING, KLPOL_ACCEPT_PARENT, KLPOL_FORCE_DISTRIB2CHILDREN } }: {
        nPolicy: number,
        pPolicyData: {
            KLPOL_DN: string,
            KLPOL_ACTIVE: boolean,
            KLPOL_ROAMING: boolean,
            KLPOL_ACCEPT_PARENT: boolean,
            KLPOL_FORCE_DISTRIB2CHILDREN: boolean
        }
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    CopyOrMovePolicy({ nPolicy, nNewGroupId, bDeleteOrigin, pExtraData }: {
        nPolicy: number,
        nNewGroupId: number,
        bDeleteOrigin?: boolean,
        pExtraData?: Partial<Pick<PolicyData, 'KLPOL_DN' | 'KLPOL_ACTIVE'>>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    DeletePolicy({ nPolicy }: {
        nPolicy: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetEffectivePoliciesForGroup({ nGroupId }: {
        nGroupId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<PolicyData[]>,
    RevertPolicyToRevision({ nPolicy, nRevisionId }: {
        nPolicy: number,
        nRevisionId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetOutbreakPolicies(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<OutbreakPolicy[]>,
    SetOutbreakPolicies({ pData }: {
        pData: OutbreakPolicy[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    ExportPolicy(params: { lPolicy: number }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    ImportPolicy(params: { lGroup: number, pData: Blob }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
}
