import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = ProductBackendIntegration;
type ProductBackendIntegration = BaseOpenAPIClient & {
    SetIntegrationToken({ wstrProdName, wstrProdVersion, pRefreshToken, nTokenTtl }: {
        wstrProdName: string,
        wstrProdVersion: string,
        pRefreshToken: string,
        nTokenTtl: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    DeleteIntegrationToken({ wstrProdName, wstrProdVersion }: {
        wstrProdName: string,
        wstrProdVersion: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    IfIntegrationAccessTokenValid({ wstrProdName, wstrProdVersion }: {
        wstrProdName: string,
        wstrProdVersion: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>
}
