import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = ProductUserTokenIssuer;
type ProductUserTokenIssuer = BaseOpenAPIClient & {
    IssueUserToken({ wstrProductName, wstrProductVersion }: {
        wstrProductName: string,
        wstrProductVersion: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    RevokeUserToken({ wstrProductName, wstrProductVersion }: {
        wstrProductName: string,
        wstrProductVersion: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>
}
