import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = QBTNetworkListApi;
type QBTNetworkListApi = BaseOpenAPIClient & {
    AddListItemsTask({ listName, pItemsIds, taskName }: {
        listName: string,
        pItemsIds: number[],
        taskName: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    AddListItemTask({ listName, itemId, taskName }: {
        listName: string,
        itemId: number,
        taskName: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetListItemInfo({ itemId }: {
        itemId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{
        strHostName: string,
        strListName: string,
        strId: string,
        strListProductName: string,
        strListProductVersion: string
    }>
}
