import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { ParamDateTime } from '../../data/common'
import BaseOpenAPIClient = require('../base-open-api-client');

export = QueriesStorage;

type QueryData = {
    Name: string,
    PredefinedID: string,
    Query?: string
} | {
    ColumnCount: number,
    PageTitle: string,
    panes: ({
        KLRPT_DSH_TYPE: number, // Dashboard type. Required.
        id?: number, // Dashboard scope administration group ID.
        KLRPT_QUERY_ID?: number, // Hosts query identity if dashboard is created for a hosts query. Must be <= 0 or absent if the dashboard is created for a group.
        bIncludeVS?: boolean, // True if data from Virtual Servers is included. Optional. The default value is true.
        KLPPT_StatFinishTime?: ParamDateTime, // Finish time, for histogram and diagram dashboards. Statistics building time is used if the parameter is less than 0 or absent.
        KLPPT_StatPeriodInSec?: number, // Period of time to monitor in seconds, for histogram and diagram dashboards (used to calculate KLPPT_StatStartTime = KLPPT_StatFinishTime //KLPPT_StatPeriodInSec if KLPPT_StatStartTime is less than 0 or absent). Must be less than 0 or absent if 'KLPPT_StatStartTime' is used.
        KLPPT_StatStartTime?: ParamDateTime // Start time, for histogram and diagram dashboards. Must be invalid or absent if 'KLPPT_StatPeriodInSec' is used.
    } & Record<string, any>)[]
}

type QueriesStorage = BaseOpenAPIClient & {
    GetQuery({ nId }: {
        nId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    GetQueryIds(eType: number, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    GetQueries(eType: number, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    DeleteQuery(nId: number, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    AddQuery({ eType, query }: {
        eType: number,
        query: QueryData
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    UpdateQuery({ nId, query }: {
        nId: number,
        query: QueryData
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    ExportQuery({ nId }: {
        nId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Blob>,
    ImportQuery({ eRequiredType, pData }: {
        eRequiredType: number,
        pData: Blob
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>
}
